create or replace package body tbicds.PCK_DEMOGRAPHICS is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

   /*get relationship recordset*/
   procedure GetRelationshipSelfRS(
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out RetRefCursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * '
                || 'from tbicds.stat_relationship t '
                || 'where active = 1 '
                || 'or t.relationship_id = 9 '
                || 'order by active ';
      open rs for v_vSql;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_DEMOGRAPHICS.GetRelationshipSelfRS(): ' || sqlErrm;
   end;
   
   /*get state recordset*/
   procedure GetStateRS(
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out RetRefCursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * from tbicds.stat_states t where active = 1';
      open rs for v_vSql;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_DEMOGRAPHICS.GetStateRS(): ' || sqlErrm;
   end;
   
   /*get gender recordset*/
   procedure GetGenderRS(
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out RetRefCursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * from tbicds.stat_gender t where active = 1';
      open rs for v_vSql;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_DEMOGRAPHICS.GetGenderRS(): ';
   end;
   
   /*get gender description by id recordset*/
   procedure GetGenderDescByIdRS (
      pi_vSessionID              in varchar2,
      pi_vSessionClientIP        in varchar2,
      pi_nUserID                 in number,
      pi_vGenderID               in varchar2,
      po_nStatusCode             out number,
      po_vStatusComment          out varchar2,
      rs                         out RetRefCursor
     )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode := 0;--0 = success
      po_vStatusComment := '';
   
      --open recordset
      v_vSql := 'select * from tbicds.stat_gender t where t.gender_id = :P0 and t.active = 1';
      open rs for v_vSql using pi_vGenderID;
   
   exception
      when others
      then
         po_nStatusCode := 1;
         po_vStatusComment := 'PCK_DEMOGRAPHICS.GetGenderDescByIdRS(): ';
   end;

end;
/

